<?php
    header("Content-Type:application/json");
    header("Access-Control-Allow-Origin: http://localhost:5500");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");

    // forzar a que se haga un GET
    if ($_SERVER['REQUEST_METHOD']!= "GET")
        badEnd("400", array("msg"=>"Debe llamarse al servicio usando un GET"));

    // parametros obligatorios
    $parmsob = array("id", "sessionid");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    // parametros opcoinales
    $distanceid = 0;
    if (isset($_REQUEST["distanceid"])){
        $distanceid = intval($_REQUEST["distanceid"]);
    }
    $racecourseid = 0;
    if (isset($_REQUEST["racecourseid"])){
        $racecourseid = intval($_REQUEST["racecourseid"]);
    }

    $sessionid = preg_replace("/[^a-zA-Z0-9]+/", "", $_REQUEST["sessionid"]);
    $id = intval($_REQUEST["id"]);

    isSessionValid($db, $sessionid);

    if (!tienePrivilegio($db, $sessionid, 460, false))
        badEnd("403", array("msg"=>"No tiene privilegios para ejecutar esta acción"));
    
    // obtener los ultimos valores de carrera
    $sql =  "SELECT     H.raceid,  " . 
            "           J.id jockeyid, CONCAT(J.names, ' ', J.lastnames) jockeydsc, J.abbr jockeyabbr, " .
            "           T.id trainerid, CONCAT(T.names, ' ', T.lastnames) trainerdsc, T.abbr trainerabbr, " .
            "           S.id studid, S.dsc studdsc, S.abbr studabbr, " .
            "           IFNULL(H.weight,0) horseweight, IFNULL(H.jockeyweight, '') jockeyweight " .
            "FROM       racers H " . 
            "INNER JOIN races R " . 
            "ON         H.raceid = R.id " .
            "INNER JOIN jockeys J " .
            "ON         H.jockeyid=J.id " .
            "INNER JOIN trainers T " .
            "ON         H.trainerid=T.id " .
            "INNER JOIN studs S " .
            "ON         H.studid=S.id " .
            "WHERE      horseid=" . $id . " ". 
            "AND        R.status=2 " .
            "ORDER BY   raceid DESC ";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    $trainer = new stdClass;
    $trainer->id = 0;
    $trainer->name = "";
    $trainer->abbr = "";
    $jockey = new stdClass;
    $jockey->id = 0;
    $jockey->name = "";
    $jockey->abbr = "";
    $stud = new stdClass;
    $stud->id = 0;
    $stud->name = "";
    $stud->abbr = "";
    $weight = 0;
    $jockeyweight = "";
    if ($row = $rs->fetch_assoc()){
        $trainer->id = (integer) $row["trainerid"];
        $trainer->name = $row["trainerdsc"];
        $trainer->abbr = $row["trainerabbr"];
        $jockey->id = (integer) $row["jockeyid"];
        $jockey->name = $row["jockeydsc"];
        $jockey->abbr = $row["jockeyabbr"];
        $stud->id = (integer) $row["studid"];
        $stud->name = $row["studdsc"];
        $stud->abbr = $row["studabbr"];
        $weight = (float) $row["horseweight"];
        $jockeyweight = $row["jockeyweight"];
    }

    // historia del caballo
    $addwhere = "";
    if ($racecourseid != 0){
        $addwhere .= " AND racecourseid=" . $racecourseid . " ";
    }
    if ($distanceid != 0){
        $addwhere .= " AND distanceid=" . $distanceid . " ";
    }

    $sql =  "SELECT     * " .
            "FROM       wrk_horsehistory " . 
            "WHERE      horseid = " . $id . " " . $addwhere .
            "ORDER BY   date DESC";
    if (!$rs = $db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    $history = array();
    while ($row = $rs->fetch_assoc()){
        $race = new stdClass;
        $race->hippodrome = new stdClass;
        $race->hippodrome->id = (integer) $row["racecourseid"];
        $race->hippodrome->name = $row["racecoursename"];
        $race->date = new stdClass;            
        $race->date->date = $row["date"];
        $race->date->formatted = $row["datefmt"];
        $race->racenumber = $row["racenumber"];
        $race->jockey = new stdClass;            
        $race->jockey->id = (integer) $row["jockeyid"];
        $race->jockey->name = $row["jockeydsc"];
        $race->trainner = new stdClass;            
        $race->trainner->id = (integer) $row["trainerid"];
        $race->trainner->name = $row["trainerdsc"];
        $race->distance = new stdClass;            
        $race->distance->id = (integer) $row["distanceid"];
        $race->distance->name = $row["distancename"];
        $race->finishtime = (float) $row["finishtime"];
        $race->speedrating = (float)  $row["srating"];
        $race->position = (float) $row["position"];
        $race->arrivalposition = (float) $row["arrivalposition"];
        $race->weight = (float) $row["weight"];

        $history[] = $race;
    }

    // estadísticas del caballo
    $sql =  "SELECT     SUM(firstplace) firstplace, " . 
            "           SUM(secondplace) secondplace, " .
            "           SUM(thirdplace) thirdplace, " .
            "           SUM(fourthplace) fourthplace, " .
            "           SUM(fifthplace) fifthplace, " .
            "           SUM(nowinplace) nowinplace, " .
            "           SUM(noplace) noplace, " .
            "           SUM(totalraces) totalraces, " .
            "           SUM(pricesbs) pricesbs, " .
            "           SUM(pricesusd) pricesusd " .
            "FROM       stats_horses " . 
            "WHERE      horseid=" . $id . " " . $addwhere . 
            "GROUP BY   horseid";
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql, "msg"=>$db->error));
    $summaries = new stdClass;
    $summaries->positions = new stdClass;
    $summaries->positions->first = 0;
    $summaries->positions->second = 0;
    $summaries->positions->third = 0;
    $summaries->positions->fourth = 0;
    $summaries->positions->fifth = 0;
    $summaries->positions->noappear = 0;
    $summaries->qty = new stdClass;
    $summaries->qty->win = 0;
    $summaries->qty->nowin = 0;
    $summaries->qty->total = 0;
    $summaries->prices = new stdClass;
    $summaries->prices->bs = new stdClass;
    $summaries->prices->bs->number = 0;
    $summaries->prices->bs->formatted = "0.00";
    $summaries->prices->usd = new stdClass;
    $summaries->prices->usd->number = 0;
    $summaries->prices->usd->formatted = "0.00";
    if ($row = $rs->fetch_assoc()){
        $summaries->positions->first = (integer) $row["firstplace"];
        $summaries->positions->second = (integer) $row["secondplace"];
        $summaries->positions->third = (integer) $row["thirdplace"];
        $summaries->positions->fourth = (integer) $row["fourthplace"];
        $summaries->positions->fifth = (integer) $row["fifthplace"];
        $summaries->positions->noappear = (integer) $row["noplace"];
        $summaries->qty->win = (integer) $row["firstplace"];
        $summaries->qty->nowin = (integer) $row["totalraces"] - (integer) $row["firstplace"];
        $summaries->qty->total = (integer) $row["totalraces"];
        $summaries->prices->bs->number = (float) $row["pricesbs"];
        $summaries->prices->bs->formatted = number_format($summaries->prices->bs->number, 2, ",", ".");
        $summaries->prices->usd->number = (float) $row["pricesusd"];
        $summaries->prices->usd->formatted = number_format($summaries->prices->usd->number, 2, ",", ".");
    }

    $sql =  "SELECT     H.id, H.dsc, H.abbr, H.status, H.gender, IFNULL(H.origin, '') origin, H.obs, " .
            "           H.createdat created, DATE_FORMAT(H.createdat, '%d/%m/%Y %h:%i %p') createdfmt, " .
            "           H.modifiedat modified, DATE_FORMAT(H.modifiedat, '%d/%m/%Y %h:%i %p') modifiedfmt, " .
            "           H.fatherid, H.fathername, H.motherid, H.mothername, H.fathergfname, H.fathergmname,  " .
            "           H.mothergfname, H.mothergmname, DATEDIFF(NOW(), H.birthdate)/365 age, " .
            "           H.`fatherobs`, H.`motherobs`, H.`fathergfobs`, H.`fathergmobs`, H.`mothergfobs`, H.`mothergmobs`,  " .
            "           H.birthdate,  DATE_FORMAT(H.birthdate, '%d-%m-%Y') birthdatefmt, " .
            "           F.id fid, F.dsc fdsc, F.abbr fabbr,  " .
            "           A.id aid, A.dsc adsc, A.abbr aabbr " .
            "FROM       horses H " .
            "INNER JOIN furs F " .
            "ON         H.furid=F.id " .
            "INNER JOIN haras A " . 
            "ON         H.harasid=A.id " .
            "WHERE      H.id = " . $id;
    if (!$rs = $db->query($sql))
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));

    if ($row = $rs->fetch_assoc()){
        $entry = new stdClass;
        $entry->id = (integer) $row["id"];
        $entry->name = $row["dsc"];
        $entry->abbr = $row["abbr"];
        $entry->origin = $row["origin"];
        $entry->age = (integer) $row["age"];
        $entry->birthdate = new stdClass;
        $entry->birthdate->date = $row["birthdate"];
        $entry->birthdate->formatted = $row["birthdatefmt"];
        $entry->gender = new stdClass;
        $entry->gender->id = $row["gender"];
        $entry->gender->name = $entry->gender->id=="Y" ? "Yegua" : "Caballo";
        $entry->fur = new stdClass;
        $entry->fur->id = (integer) $row["fid"];
        $entry->fur->name = $row["fdsc"];
        $entry->haras = new stdClass;
        $entry->haras->id = (integer) $row["aid"];
        $entry->haras->name = $row["adsc"];
        $entry->lasttrainer = $trainer;
        $entry->lastjockey = $jockey;
        $entry->laststud = $stud;
        $entry->lastweight = $weight;
        $entry->lastjockeyweight = $jockeyweight;
        $entry->status = new stdClass;
        $entry->status->id = (integer) $row["status"];
        $entry->status->name = $entry->status->id==0 ? "Inactivo" : "Activo";
        $entry->lineage = new stdClass;
        $entry->lineage->father = new stdClass;
        $entry->lineage->father->id = (integer) $row["fatherid"];
        $entry->lineage->father->name = nvl($row["fathername"], "");
        $entry->lineage->father->obs = nvl($row["fatherobs"], "");
        $entry->lineage->father->lineage = new stdClass;
        $entry->lineage->father->lineage->father = new stdClass;
        $entry->lineage->father->lineage->father->name = nvl($row["fathergfname"], "");
        $entry->lineage->father->lineage->father->obs = nvl($row["fathergfobs"], "");
        $entry->lineage->father->lineage->mother = new stdClass;
        $entry->lineage->father->lineage->mother->name = nvl($row["fathergmname"], "");
        $entry->lineage->father->lineage->mother->obs = nvl($row["fathergmobs"], "");
        $entry->lineage->mother = new stdClass;
        $entry->lineage->mother->id = (integer) $row["motherid"];
        $entry->lineage->mother->name = nvl($row["mothername"], "");
        $entry->lineage->mother->obs = nvl($row["motherobs"], "");
        $entry->lineage->mother->lineage = new stdClass;
        $entry->lineage->mother->lineage->father = new stdClass;
        $entry->lineage->mother->lineage->father->name = nvl($row["mothergfname"], "");
        $entry->lineage->mother->lineage->father->obs = nvl($row["mothergfobs"], "");
        $entry->lineage->mother->lineage->mother = new stdClass;
        $entry->lineage->mother->lineage->mother->name = nvl($row["mothergmname"], "");
        $entry->lineage->mother->lineage->mother->obs = nvl($row["mothergmobs"], "");

        $entry->obs = nvl($row["obs"], "");
        $entry->races = new stdClass;
        $entry->races->history = $history;
        $entry->races->summaries = $summaries;
        $entry->created = new stdClass;
        $entry->created->date = $row["created"];
        $entry->created->formatted = $row["createdfmt"];
        $entry->modified = new stdClass;
        $entry->modified->date = $row["modified"];
        $entry->modified->formatted = $row["modifiedfmt"];
    }else{
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }

    $out = new stdClass;
    $out->entry = $entry;

    $access = array();
    $access["read"] = tienePrivilegio($db, $sessionid, 460);
    $access["update"] = tienePrivilegio($db, $sessionid, 461);
    $access["create"] = tienePrivilegio($db, $sessionid, 462);
    $access["delete"] =   tienePrivilegio($db, $sessionid, 463);
    $out->privileges = $access;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>